/*
 * Copyright (C) 2012-2025 Japan Smartphone Security Association
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jssec.android.autofillframework.autofillservice;

import android.app.assist.AssistStructure;
import android.os.CancellationSignal;
import android.service.autofill.AutofillService;
import android.service.autofill.Dataset;
import android.service.autofill.FillCallback;
import android.service.autofill.FillContext;
import android.service.autofill.FillRequest;
import android.service.autofill.FillResponse;
import android.service.autofill.SaveCallback;
import android.service.autofill.SaveRequest;
import android.view.View;

import java.util.List;

public class MyAutofillService extends AutofillService {

    @Override
    public void onFillRequest(FillRequest request, CancellationSignal cancellationSignal,
                              FillCallback callback) {
        AssistStructure structure = request.getFillContexts()
            .get(request.getFillContexts().size() - 1).getStructure();

        StructureParser parser = new StructureParser(structure);
        parser.parseForFill();
        Database db = new Database(this);
        FillResponse response = AutofillHelper.createFillResponse(this, parser.getFieldId(View.AUTOFILL_HINT_USERNAME), parser.getFieldId(View.AUTOFILL_HINT_PASSWORD), db.getAllList());
        callback.onSuccess(response);
    }

    @Override
    public void onSaveRequest(SaveRequest request, SaveCallback callback) {
        List<FillContext> context = request.getFillContexts();
        final AssistStructure structure = context.get(context.size() - 1).getStructure();

        StructureParser parser = new StructureParser(structure);
        parser.parseForSave();

        // Processing for storing
        Database db = new Database(this);
        db.add(parser.getValue(View.AUTOFILL_HINT_USERNAME), parser.getValue(View.AUTOFILL_HINT_PASSWORD));
    }
}
